<?php

/**
 * PayTrack - Index Page
 * Redirects to appropriate dashboard or login
 */

require_once 'config/config.php';

// Check if user is logged in
if (isLoggedIn()) {
  // Redirect to appropriate dashboard based on role
  if (hasRole('employee')) {
    header("Location: " . BASE_URL . "/employee/dashboard.php");
  } else {
    header("Location: " . BASE_URL . "/company/dashboard.php");
  }
} else {
  // Redirect to login page
  header("Location: " . BASE_URL . "/login.php");
}

exit();
