<?php
if (!isLoggedIn()) {
  return;
}

$userInfo = getUserInfo($_SESSION['user_id']);
$isEmployee = hasRole('employee');
$isCompany = hasRole('company');

// Get employee info if employee
$employeeInfo = null;
if ($isEmployee) {
  $employeeInfo = getEmployeeInfo($_SESSION['user_id']);
}
?>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary sticky-top shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?php echo BASE_URL; ?>/<?php echo $isEmployee ? 'employee' : 'company'; ?>/dashboard.php">
      <i class="bi bi-wallet2"></i> <?php echo APP_NAME; ?>
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <?php if ($isEmployee): ?>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/employee/dashboard.php">
              <i class="bi bi-speedometer2"></i> Dashboard
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/employee/payments.php">
              <i class="bi bi-cash-stack"></i> Payment History
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/employee/monthly-report.php">
              <i class="bi bi-calendar3"></i> Monthly Report
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/employee/profile.php">
              <i class="bi bi-person"></i> Profile
            </a>
          </li>
        <?php else: ?>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/company/dashboard.php">
              <i class="bi bi-speedometer2"></i> Dashboard
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/company/employees.php">
              <i class="bi bi-people"></i> Employees
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/company/payments.php">
              <i class="bi bi-cash-coin"></i> Payments
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo BASE_URL; ?>/company/reports.php">
              <i class="bi bi-file-earmark-bar-graph"></i> Reports
            </a>
          </li>
        <?php endif; ?>
      </ul>

      <ul class="navbar-nav">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown"
            role="button" data-bs-toggle="dropdown">
            <?php if ($userInfo['profile_picture']): ?>
              <img src="<?php echo BASE_URL; ?>/assets/uploads/<?php echo $userInfo['profile_picture']; ?>"
                class="rounded-circle me-2" width="32" height="32" alt="Profile">
            <?php else: ?>
              <i class="bi bi-person-circle fs-4 me-2"></i>
            <?php endif; ?>
            <?php echo htmlspecialchars($userInfo['full_name']); ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end">
            <li>
              <span class="dropdown-item-text">
                <small class="text-muted">
                  <?php echo $isEmployee ? 'Employee' : 'Company Admin'; ?>
                </small>
              </span>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <?php if ($isEmployee): ?>
              <li>
                <a class="dropdown-item" href="<?php echo BASE_URL; ?>/employee/profile.php">
                  <i class="bi bi-person"></i> Profile
                </a>
              </li>
            <?php endif; ?>
            <li>
              <a class="dropdown-item text-danger" href="<?php echo BASE_URL; ?>/api/logout.php">
                <i class="bi bi-box-arrow-right"></i> Logout
              </a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>
</nav>