<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

// Require employee login
requireRole('employee');

// Get payment ID
$paymentId = $_GET['id'] ?? 0;

// Get payment details
require_once '../config/database.php';
$db = $pdo;
$stmt = $db->prepare("
    SELECT p.*, 
           eu.full_name as employee_name, 
           e.employee_id, 
           e.designation, 
           e.department,
           e.monthly_salary,
           e.company_name,
           au.full_name as added_by_name
    FROM payments p
    JOIN employees e ON p.employee_id = e.id
    JOIN users eu ON e.user_id = eu.id
    JOIN users au ON p.added_by = au.id
    WHERE p.id = ? AND p.employee_id = (
        SELECT id FROM employees WHERE user_id = ?
    )
");
$stmt->execute([$paymentId, $_SESSION['user_id']]);
$payment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payment) {
  die("Payment not found or access denied.");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Payment Receipt - #<?php echo $payment['id']; ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
  <style>
    @page {
      size: A4;
      margin: 0;
    }

    @media print {
      .no-print {
        display: none !important;
      }

      body {
        margin: 0;
        padding: 0;
        background: white !important;
      }

      .receipt-container {
        max-width: 100%;
        margin: 0;
        box-shadow: none !important;
        border-radius: 0 !important;
        page-break-after: avoid;
        page-break-inside: avoid;
      }

      .receipt-header {
        padding: 20px !important;
        page-break-after: avoid;
      }

      .receipt-body {
        padding: 20px !important;
      }

      .receipt-footer {
        padding: 15px 20px !important;
      }

      .company-logo {
        font-size: 36px !important;
        animation: none !important;
        margin-bottom: 6px !important;
      }

      .receipt-title {
        font-size: 20px !important;
      }

      .receipt-number {
        font-size: 11px !important;
      }

      table {
        margin-bottom: 12px !important;
        page-break-inside: avoid;
      }

      .receipt-info-table td {
        padding: 6px 10px !important;
        font-size: 11px !important;
      }

      .section-title {
        font-size: 11px !important;
        padding-bottom: 6px !important;
        margin-bottom: 8px !important;
      }

      .inner-table td {
        padding: 4px 0 !important;
        font-size: 11px !important;
      }

      .payment-table th {
        padding: 8px !important;
        font-size: 11px !important;
      }

      .payment-table td {
        padding: 10px 8px !important;
        font-size: 12px !important;
      }

      .transaction-table td {
        padding: 6px 10px !important;
        font-size: 11px !important;
      }

      .total-table td {
        padding: 12px !important;
      }

      .total-label {
        font-size: 12px !important;
      }

      .total-amount {
        font-size: 20px !important;
      }

      .notes-box {
        padding: 10px 12px !important;
        font-size: 11px !important;
      }

      .signature-section {
        page-break-inside: avoid;
        margin-top: 25px !important;
      }

      .signature-line {
        margin-top: 30px !important;
      }

      .watermark {
        display: none !important;
      }
    }

    body {
      background: linear-gradient(135deg, #e8f0fe 0%, #f0f7ff 100%);
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      margin: 0;
      padding: 0;
    }

    .receipt-container {
      max-width: 210mm;
      min-height: 297mm;
      margin: 20px auto;
      background: white;
      box-shadow: 0 10px 40px rgba(37, 99, 235, 0.12);
      border-radius: 12px;
      overflow: hidden;
    }

    .receipt-header {
      background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
      color: white;
      padding: 25px 30px;
      text-align: center;
      position: relative;
    }

    .receipt-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120"><path d="M0,0 Q300,80 600,0 T1200,0 L1200,120 L0,120 Z" fill="rgba(255,255,255,0.05)"/></svg>') no-repeat bottom;
      background-size: cover;
      opacity: 0.3;
    }

    .receipt-header * {
      position: relative;
      z-index: 1;
    }

    .company-logo {
      font-size: 42px;
      margin-bottom: 8px;
      animation: pulse 2s ease-in-out infinite;
    }

    @keyframes pulse {

      0%,
      100% {
        transform: scale(1);
      }

      50% {
        transform: scale(1.05);
      }
    }

    .receipt-title {
      font-size: 24px;
      font-weight: 700;
      margin: 0;
      text-transform: uppercase;
      letter-spacing: 2px;
    }

    .receipt-number {
      font-size: 13px;
      margin-top: 4px;
      opacity: 0.9;
    }

    .receipt-body {
      padding: 25px 30px;
    }

    /* Professional Tables */
    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 15px;
    }

    .receipt-info-table {
      border: 2px solid #2563eb;
      background: #f8fafc;
      margin-bottom: 20px;
    }

    .receipt-info-table td {
      padding: 8px 12px;
      font-size: 13px;
    }

    .label-col {
      color: #64748b;
      font-weight: 600;
      width: 20%;
    }

    .value-col {
      color: #1e293b;
      width: 30%;
    }

    .section-title {
      font-size: 12px;
      font-weight: 700;
      color: #2563eb;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      padding-bottom: 8px;
      border-bottom: 2px solid #2563eb;
      margin-bottom: 10px;
    }

    .details-table {
      border: 1px solid #cbd5e1;
      background: white;
    }

    .details-table td {
      padding: 15px;
    }

    .inner-table {
      width: 100%;
      margin: 0;
    }

    .inner-table td {
      padding: 5px 0;
      font-size: 12px;
      border: none;
    }

    .inner-label {
      color: #64748b;
      font-weight: 600;
      width: 40%;
    }

    .inner-value {
      color: #1e293b;
      width: 60%;
    }

    .payment-table {
      border: 2px solid #cbd5e1;
      background: white;
      margin-top: 10px;
    }

    .payment-table th {
      background: #2563eb;
      color: white;
      padding: 10px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .payment-table td {
      padding: 12px 10px;
      font-size: 13px;
      border-bottom: 1px solid #e2e8f0;
    }

    .transaction-table {
      background: #f8fafc;
      border: 1px solid #cbd5e1;
      margin-top: 15px;
    }

    .transaction-table td {
      padding: 8px 12px;
      font-size: 12px;
    }

    .trans-label {
      color: #64748b;
      font-weight: 600;
      width: 20%;
    }

    .trans-value {
      color: #1e293b;
      width: 30%;
    }

    .total-table {
      margin-top: 15px;
      border: 3px solid #10b981;
      background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    }

    .total-table td {
      padding: 15px;
      color: white;
    }

    .total-label {
      font-size: 14px;
      font-weight: 700;
      text-transform: uppercase;
      letter-spacing: 1px;
      width: 70%;
    }

    .total-amount {
      font-size: 24px;
      font-weight: 700;
      text-align: right;
      width: 30%;
    }

    .notes-box {
      background: #fef3c7;
      border: 2px solid #f59e0b;
      border-left: 5px solid #f59e0b;
      padding: 12px 15px;
      margin-top: 15px;
      font-size: 12px;
      color: #92400e;
    }

    .receipt-footer {
      background: #f8f9fa;
      padding: 18px 30px;
      border-top: 2px solid #2563eb;
    }

    .signature-section {
      display: flex;
      justify-content: space-between;
      margin-top: 35px;
      padding-top: 10px;
    }

    .signature-box {
      text-align: center;
      flex: 1;
    }

    .signature-line {
      width: 160px;
      border-top: 2px solid #1f2937;
      margin: 45px auto 0;
      padding-top: 8px;
      font-weight: 600;
      color: #1f2937;
      font-size: 12px;
    }



    .watermark {
      position: fixed;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%) rotate(-45deg);
      font-size: 120px;
      color: rgba(37, 99, 235, 0.03);
      font-weight: 900;
      pointer-events: none;
      z-index: 0;
    }

    .print-btn {
      position: fixed;
      bottom: 30px;
      right: 30px;
      padding: 15px 30px;
      font-size: 16px;
      font-weight: 600;
      box-shadow: 0 8px 20px rgba(37, 99, 235, 0.3);
    }
  </style>
</head>

<body>
  <div class="watermark">PAID</div>

  <div class="receipt-container">
    <!-- Receipt Header -->
    <div class="receipt-header">
      <div class="company-logo">
        <i class="bi bi-building"></i>
      </div>
      <h1 class="receipt-title">Payment Receipt</h1>
      <p class="receipt-number">Receipt #<?php echo str_pad($payment['id'], 6, '0', STR_PAD_LEFT); ?></p>
    </div>

    <!-- Receipt Body -->
    <div class="receipt-body">
      <!-- Receipt Info Table -->
      <table class="receipt-info-table">
        <tr>
          <td class="label-col">Receipt No:</td>
          <td class="value-col"><strong>#<?php echo str_pad($payment['id'], 6, '0', STR_PAD_LEFT); ?></strong></td>
          <td class="label-col">Date:</td>
          <td class="value-col"><strong><?php echo date('F d, Y'); ?></strong></td>
        </tr>
      </table>

      <!-- Company & Employee Details -->
      <table class="details-table">
        <tr>
          <td style="width: 50%; padding-right: 15px; vertical-align: top;">
            <div class="section-title">COMPANY DETAILS</div>
            <table class="inner-table">
              <tr>
                <td class="inner-label">Company Name:</td>
                <td class="inner-value"><?php echo htmlspecialchars(!empty($payment['company_name']) ? $payment['company_name'] : APP_NAME); ?></td>
              </tr>
            </table>
          </td>
          <td style="width: 50%; padding-left: 15px; vertical-align: top; border-left: 2px solid #e5e7eb;">
            <div class="section-title">EMPLOYEE DETAILS</div>
            <table class="inner-table">
              <tr>
                <td class="inner-label">Employee ID:</td>
                <td class="inner-value"><?php echo htmlspecialchars($payment['employee_id']); ?></td>
              </tr>
              <tr>
                <td class="inner-label">Name:</td>
                <td class="inner-value"><?php echo htmlspecialchars($payment['employee_name']); ?></td>
              </tr>
              <tr>
                <td class="inner-label">Designation:</td>
                <td class="inner-value"><?php echo htmlspecialchars($payment['designation']); ?></td>
              </tr>
              <tr>
                <td class="inner-label">Department:</td>
                <td class="inner-value"><?php echo htmlspecialchars($payment['department'] ?? 'N/A'); ?></td>
              </tr>
            </table>
          </td>
        </tr>
      </table>

      <!-- Payment Details Table -->
      <div class="section-title" style="margin-top: 20px;">PAYMENT DETAILS</div>
      <table class="payment-table">
        <thead>
          <tr>
            <th>Description</th>
            <th style="text-align: center;">Payment Date</th>
            <th style="text-align: center;">Payment Method</th>
            <th style="text-align: right;">Amount</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>Salary Payment</td>
            <td style="text-align: center;"><?php echo formatDate($payment['payment_date']); ?></td>
            <td style="text-align: center;"><?php echo getPaymentMethodLabel($payment['payment_method']); ?></td>
            <td style="text-align: right;"><strong><?php echo formatCurrency($payment['amount']); ?></strong></td>
          </tr>
        </tbody>
      </table>

      <!-- Transaction Details -->
      <table class="transaction-table">
        <tr>
          <td class="trans-label">Transaction ID:</td>
          <td class="trans-value"><?php echo htmlspecialchars($payment['transaction_id'] ?? 'N/A'); ?></td>
          <td class="trans-label">Processed By:</td>
          <td class="trans-value"><?php echo htmlspecialchars($payment['added_by_name']); ?></td>
        </tr>
      </table>

      <!-- Total Amount -->
      <table class="total-table">
        <tr>
          <td class="total-label">TOTAL AMOUNT PAID:</td>
          <td class="total-amount"><?php echo formatCurrency($payment['amount']); ?></td>
        </tr>
      </table>

      <!-- Notes Section -->
      <?php if (!empty($payment['notes'])): ?>
        <div class="notes-box">
          <strong>Notes:</strong> <?php echo htmlspecialchars($payment['notes']); ?>
        </div>
      <?php endif; ?>

      <!-- Signature Section -->
      <div class="signature-section">
        <div class="signature-box">
          <div class="signature-line">Employee Signature</div>
        </div>
        <div class="signature-box">
          <div class="signature-line">Authorized Signatory</div>
        </div>
      </div>
    </div>

    <!-- Receipt Footer -->
    <div class="receipt-footer">
      <div class="row align-items-center">
        <div class="col-md-8">
          <p class="mb-1" style="font-size: 12px; color: #6b7280;"><i class="bi bi-info-circle"></i> This is a computer-generated receipt and does not require a physical signature.</p>
          <p class="mb-0" style="font-size: 11px; color: #9ca3af;">Generated on <?php echo date('F d, Y \a\t h:i A'); ?></p>
        </div>
        <div class="col-md-4 text-end">
          <p class="mb-1" style="font-size: 13px;"><strong>Need help?</strong></p>
          <p class="mb-0" style="font-size: 12px; color: #6b7280;">Contact: Murtzag1986@gmail.com</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Print Button -->
  <button class="btn btn-primary btn-lg no-print print-btn" onclick="window.print()">
    <i class="bi bi-printer-fill"></i> Print Receipt
  </button>

  <script>
    // Auto print option (uncomment if needed)
    // window.onload = function() { window.print(); }
  </script>
</body>

</html>