<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

requireRole('employee');

$employeeInfo = getEmployeeInfo($_SESSION['user_id']);
if (!$employeeInfo) {
  die("Employee information not found.");
}

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * ITEMS_PER_PAGE;

// Get payments
$payments = getAllPayments($employeeInfo['id'], $offset, ITEMS_PER_PAGE);
$totalPayments = countPayments($employeeInfo['id']);
$totalPages = ceil($totalPayments / ITEMS_PER_PAGE);

$pageTitle = 'Payment History';
require_once '../includes/header.php';
require_once '../includes/navbar.php';
?>

<div class="container-fluid py-4">
  <div class="row mb-4">
    <div class="col-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
          <li class="breadcrumb-item active">Payment History</li>
        </ol>
      </nav>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0"><i class="bi bi-cash-stack"></i> Complete Payment History</h5>
          <div>
            <button class="btn btn-success btn-sm" onclick="window.print()">
              <i class="bi bi-printer"></i> Print
            </button>
          </div>
        </div>
        <div class="card-body">
          <?php if (count($payments) > 0): ?>
            <div class="table-responsive">
              <table class="table table-hover data-table">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Transaction ID</th>
                    <th>Notes</th>
                    <th>Added By</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($payments as $index => $payment): ?>
                    <tr>
                      <td><?php echo $offset + $index + 1; ?></td>
                      <td><?php echo formatDate($payment['payment_date']); ?></td>
                      <td><strong class="text-success"><?php echo formatCurrency($payment['amount']); ?></strong></td>
                      <td>
                        <span class="badge bg-secondary">
                          <?php echo getPaymentMethodLabel($payment['payment_method']); ?>
                        </span>
                      </td>
                      <td><code><?php echo htmlspecialchars($payment['transaction_id'] ?? 'N/A'); ?></code></td>
                      <td><?php echo htmlspecialchars($payment['notes'] ?? '-'); ?></td>
                      <td><?php echo htmlspecialchars($payment['added_by_name']); ?></td>
                      <td>
                        <a href="<?php echo BASE_URL; ?>/employee/print-receipt.php?id=<?php echo $payment['id']; ?>"
                          class="btn btn-sm btn-outline-primary" target="_blank">
                          <i class="bi bi-printer"></i> Print
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
                <tfoot>
                  <tr class="table-active">
                    <th colspan="2">Total</th>
                    <th colspan="5">
                      <strong class="text-success">
                        <?php echo formatCurrency(getTotalPayments($employeeInfo['id'])); ?>
                      </strong>
                    </th>
                  </tr>
                </tfoot>
              </table>
            </div>

            <?php if ($totalPages > 1): ?>
              <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center">
                  <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                      <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                  <?php endfor; ?>
                </ul>
              </nav>
            <?php endif; ?>
          <?php else: ?>
            <div class="text-center py-5">
              <i class="bi bi-inbox display-1 text-muted"></i>
              <h4 class="mt-3 text-muted">No payments recorded yet</h4>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once '../includes/footer.php'; ?>