<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

requireRole('employee');

$employeeInfo = getEmployeeInfo($_SESSION['user_id']);
if (!$employeeInfo) {
  die("Employee information not found.");
}

$monthlyBreakdown = getMonthlyBreakdown($employeeInfo['id']);

$pageTitle = 'Monthly Report';
require_once '../includes/header.php';
require_once '../includes/navbar.php';
?>

<div class="container-fluid py-4">
  <div class="row mb-4">
    <div class="col-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
          <li class="breadcrumb-item active">Monthly Report</li>
        </ol>
      </nav>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0"><i class="bi bi-calendar3"></i> Month-wise Salary Breakdown</h5>
          <button class="btn btn-success btn-sm no-print" onclick="window.print()">
            <i class="bi bi-printer"></i> Print Report
          </button>
        </div>
        <div class="card-body">
          <?php if (count($monthlyBreakdown) > 0): ?>
            <div class="table-responsive">
              <table class="table table-hover data-table">
                <thead>
                  <tr>
                    <th>Month</th>
                    <th>Expected Salary</th>
                    <th>Amount Paid</th>
                    <th>Balance</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($monthlyBreakdown as $month): ?>
                    <tr>
                      <td><strong><?php echo $month['month']; ?></strong></td>
                      <td><?php echo formatCurrency($month['expected']); ?></td>
                      <td class="text-success"><strong><?php echo formatCurrency($month['paid']); ?></strong></td>
                      <td class="text-danger"><?php echo formatCurrency($month['balance']); ?></td>
                      <td><?php echo getStatusBadge($month['status']); ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center py-5">
              <i class="bi bi-calendar-x display-1 text-muted"></i>
              <h4 class="mt-3 text-muted">No monthly data available</h4>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once '../includes/footer.php'; ?>