<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

// Require employee login
requireRole('employee');

// Get employee information
$employeeInfo = getEmployeeInfo($_SESSION['user_id']);

if (!$employeeInfo) {
  die("Employee information not found. Please contact administrator.");
}

// Get financial data
$totalEarned = getTotalEarned($employeeInfo['id']);
$totalReceived = getTotalPayments($employeeInfo['id']);
$pendingAmount = getPendingAmount($employeeInfo['id']);
$recentPayments = getRecentPayments($employeeInfo['id'], 5);

// Calculate months worked
$joiningDate = new DateTime($employeeInfo['joining_date']);
$currentDate = new DateTime();
$interval = $joiningDate->diff($currentDate);
$monthsWorked = ($interval->y * 12) + $interval->m + 1;
$yearsMonths = $interval->y . ' years, ' . $interval->m . ' months';

// Calculate payment percentage
$paymentPercentage = $totalEarned > 0 ? ($totalReceived / $totalEarned) * 100 : 0;

$pageTitle = 'Employee Dashboard';
require_once '../includes/header.php';
?>

<?php require_once '../includes/navbar.php'; ?>

<div class="container-fluid py-3">
  <!-- Welcome Section -->
  <div class="row mb-3">
    <div class="col-12">
      <div class="alert alert-primary border-0" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
        <h5 class="mb-1 text-white">
          <i class="bi bi-person-circle"></i> <?php echo htmlspecialchars($employeeInfo['full_name'] ?? $_SESSION['full_name']); ?>
        </h5>
        <p class="mb-0 text-white opacity-90 small"><?php echo htmlspecialchars($employeeInfo['designation'] ?? 'Employee'); ?> • Joined <?php echo formatDate($employeeInfo['joining_date']); ?></p>
      </div>
    </div>
  </div>



  <!-- Financial Summary Cards -->
  <div class="row mb-3">
    <div class="col-lg-3 col-md-6 mb-3">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-body p-3">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <p class="text-muted mb-1 small">Monthly Salary</p>
              <h4 class="mb-0 text-primary"><?php echo formatCurrency($employeeInfo['monthly_salary']); ?></h4>
            </div>
            <div class="bg-primary bg-opacity-10 p-2 rounded">
              <i class="bi bi-wallet2 text-primary fs-4"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-body p-3">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <p class="text-muted mb-1 small">Total Received</p>
              <h4 class="mb-0 text-success"><?php echo formatCurrency($totalReceived); ?></h4>
            </div>
            <div class="bg-success bg-opacity-10 p-2 rounded">
              <i class="bi bi-cash-coin text-success fs-4"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-body p-3">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <p class="text-muted mb-1 small">Pending Amount</p>
              <h4 class="mb-0 text-danger"><?php echo formatCurrency($pendingAmount); ?></h4>
            </div>
            <div class="bg-danger bg-opacity-10 p-2 rounded">
              <i class="bi bi-exclamation-circle text-danger fs-4"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-body p-3">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <p class="text-muted mb-1 small">Payment Progress</p>
              <h4 class="mb-0 text-info"><?php echo number_format($paymentPercentage, 1); ?>%</h4>
            </div>
            <div class="bg-info bg-opacity-10 p-2 rounded">
              <i class="bi bi-percent text-info fs-4"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>



  <div class="row">
    <!-- Recent Payments & Chart Side by Side -->
    <div class="col-xl-8 mb-3">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
          <span><i class="bi bi-clock-history"></i> Recent Payments</span>
          <a href="payments.php" class="btn btn-sm btn-primary">View All <i class="bi bi-arrow-right"></i></a>
        </div>
        <div class="card-body">
          <?php if (count($recentPayments) > 0): ?>
            <div class="table-responsive">
              <table class="table table-hover table-sm mb-0">
                <thead>
                  <tr>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Transaction ID</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($recentPayments as $payment): ?>
                    <tr>
                      <td class="small"><?php echo formatDate($payment['payment_date']); ?></td>
                      <td><strong class="text-success"><?php echo formatCurrency($payment['amount']); ?></strong></td>
                      <td>
                        <span class="badge bg-secondary">
                          <?php echo getPaymentMethodLabel($payment['payment_method']); ?>
                        </span>
                      </td>
                      <td><code class="small"><?php echo htmlspecialchars($payment['transaction_id'] ?? 'N/A'); ?></code></td>
                      <td>
                        <a href="<?php echo BASE_URL; ?>/employee/print-receipt.php?id=<?php echo $payment['id']; ?>"
                          class="btn btn-sm btn-outline-primary" target="_blank" title="Print Receipt">
                          <i class="bi bi-printer"></i>
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center py-4">
              <i class="bi bi-inbox display-4 text-muted"></i>
              <p class="text-muted mt-2 mb-0">No payments recorded yet</p>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- Payment Status Chart & Quick Actions -->
    <div class="col-xl-4 mb-3">
      <div class="card mb-3">
        <div class="card-header">
          <i class="bi bi-pie-chart"></i> Payment Status
        </div>
        <div class="card-body p-3">
          <canvas id="paymentChart" height="200"></canvas>
        </div>
      </div>

      <div class="card">
        <div class="card-header">
          <i class="bi bi-lightning"></i> Quick Actions
        </div>
        <div class="card-body p-3">
          <div class="d-grid gap-2">
            <a href="payments.php" class="btn btn-outline-primary btn-sm">
              <i class="bi bi-list-ul"></i> All Payments
            </a>
            <a href="monthly-report.php" class="btn btn-outline-success btn-sm">
              <i class="bi bi-calendar-month"></i> Monthly Report
            </a>
            <a href="profile.php" class="btn btn-outline-info btn-sm">
              <i class="bi bi-person-gear"></i> Update Profile
            </a>
            <a href="payments.php?export=pdf" class="btn btn-outline-warning btn-sm">
              <i class="bi bi-download"></i> Export Report
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  // Payment Status Chart
  const ctx = document.getElementById('paymentChart').getContext('2d');
  const paymentChart = new Chart(ctx, {
    type: 'doughnut',
    data: {
      labels: ['Received', 'Pending'],
      datasets: [{
        data: [<?php echo $totalReceived; ?>, <?php echo $pendingAmount; ?>],
        backgroundColor: [
          'rgba(25, 135, 84, 0.8)',
          'rgba(220, 53, 69, 0.8)'
        ],
        borderColor: [
          'rgba(25, 135, 84, 1)',
          'rgba(220, 53, 69, 1)'
        ],
        borderWidth: 2
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          position: 'bottom',
        },
        title: {
          display: true,
          text: 'Payment Distribution'
        }
      }
    }
  });
</script>

<?php require_once '../includes/footer.php'; ?>