<?php

/**
 * Database Configuration
 * PayTrack - Professional Salary Management System
 */

// Database credentials
define('DB_HOST', 'localhost');
define('DB_NAME', 'paytrack');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Create PDO connection
try {
  $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
  $options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ];

  $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
} catch (PDOException $e) {
  die("Database connection failed: " . $e->getMessage());
}

// Function to test database connection
function testConnection()
{
  global $pdo;
  try {
    $pdo->query("SELECT 1");
    return true;
  } catch (PDOException $e) {
    return false;
  }
}
