<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

requireRole('company');

$employees = getAllEmployees();

$pageTitle = 'Reports';
require_once '../includes/header.php';
require_once '../includes/navbar.php';
?>

<div class="container-fluid py-4">
  <div class="row mb-4">
    <div class="col-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
          <li class="breadcrumb-item active">Reports</li>
        </ol>
      </nav>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0"><i class="bi bi-file-earmark-bar-graph"></i> Employee Payment Reports</h5>
          <button class="btn btn-success btn-sm no-print" onclick="window.print()">
            <i class="bi bi-printer"></i> Print Report
          </button>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-hover data-table">
              <thead>
                <tr>
                  <th>Employee ID</th>
                  <th>Name</th>
                  <th>Designation</th>
                  <th>Monthly Salary</th>
                  <th>Total Earned</th>
                  <th>Total Received</th>
                  <th>Pending Amount</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($employees as $emp): ?>
                  <?php
                  $totalEarned = getTotalEarned($emp['id']);
                  $totalReceived = getTotalPayments($emp['id']);
                  $pending = getPendingAmount($emp['id']);
                  $percentage = $totalEarned > 0 ? ($totalReceived / $totalEarned) * 100 : 0;
                  ?>
                  <tr>
                    <td><code><?php echo htmlspecialchars($emp['employee_id']); ?></code></td>
                    <td><strong><?php echo htmlspecialchars($emp['full_name']); ?></strong></td>
                    <td><?php echo htmlspecialchars($emp['designation']); ?></td>
                    <td><?php echo formatCurrency($emp['monthly_salary']); ?></td>
                    <td><?php echo formatCurrency($totalEarned); ?></td>
                    <td class="text-success"><strong><?php echo formatCurrency($totalReceived); ?></strong></td>
                    <td class="text-danger"><strong><?php echo formatCurrency($pending); ?></strong></td>
                    <td>
                      <div class="progress" style="height: 25px;">
                        <div class="progress-bar bg-success" role="progressbar"
                          style="width: <?php echo $percentage; ?>%">
                          <?php echo number_format($percentage, 1); ?>%
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
              <tfoot>
                <tr class="table-active">
                  <th colspan="4">Total</th>
                  <th>
                    <?php
                    $grandTotalEarned = 0;
                    $grandTotalReceived = 0;
                    $grandTotalPending = 0;
                    foreach ($employees as $emp) {
                      $grandTotalEarned += getTotalEarned($emp['id']);
                      $grandTotalReceived += getTotalPayments($emp['id']);
                      $grandTotalPending += getPendingAmount($emp['id']);
                    }
                    echo formatCurrency($grandTotalEarned);
                    ?>
                  </th>
                  <th class="text-success"><?php echo formatCurrency($grandTotalReceived); ?></th>
                  <th class="text-danger"><?php echo formatCurrency($grandTotalPending); ?></th>
                  <th>
                    <?php
                    $overallPercentage = $grandTotalEarned > 0 ? ($grandTotalReceived / $grandTotalEarned) * 100 : 0;
                    echo number_format($overallPercentage, 1) . '%';
                    ?>
                  </th>
                </tr>
              </tfoot>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once '../includes/footer.php'; ?>