<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

requireRole('company');

$success = '';
$error = '';

// Handle Add Employee
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_employee'])) {
  $fullName = sanitizeInput($_POST['full_name']);
  $email = sanitizeInput($_POST['email']);
  $password = $_POST['password'];
  $employeeId = sanitizeInput($_POST['employee_id']);
  $companyName = sanitizeInput($_POST['company_name']);
  $joiningDate = sanitizeInput($_POST['joining_date']);
  $monthlySalary = sanitizeInput($_POST['monthly_salary']);
  $designation = sanitizeInput($_POST['designation']);
  $department = sanitizeInput($_POST['department']);

  if (empty($fullName) || empty($email) || empty($password) || empty($employeeId) || empty($joiningDate) || empty($monthlySalary)) {
    $error = 'Please fill all required fields.';
  } else {
    try {
      $pdo->beginTransaction();

      // Create user account
      $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
      $stmt = $pdo->prepare("INSERT INTO users (full_name, email, password, role) VALUES (?, ?, ?, 'employee')");
      $stmt->execute([$fullName, $email, $hashedPassword]);
      $userId = $pdo->lastInsertId();

      // Create employee record
      $stmt = $pdo->prepare("INSERT INTO employees (user_id, employee_id, company_name, joining_date, monthly_salary, designation, department) 
                                   VALUES (?, ?, ?, ?, ?, ?, ?)");
      $stmt->execute([$userId, $employeeId, $companyName, $joiningDate, $monthlySalary, $designation, $department]);

      $pdo->commit();
      $success = 'Employee added successfully!';
    } catch (PDOException $e) {
      $pdo->rollBack();
      $error = 'Error: ' . $e->getMessage();
    }
  }
}

$employees = getAllEmployees();

$pageTitle = 'Manage Employees';
require_once '../includes/header.php';
require_once '../includes/navbar.php';
?>

<div class="container-fluid py-4">
  <div class="row mb-4">
    <div class="col-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Employees</li>
        </ol>
      </nav>
    </div>
  </div>

  <?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show">
      <?php echo $success; ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show">
      <?php echo $error; ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="row">
    <div class="col-md-4 mb-4">
      <div class="card">
        <div class="card-header">
          <i class="bi bi-person-plus"></i> Add New Employee
        </div>
        <div class="card-body">
          <form method="POST">
            <input type="hidden" name="add_employee" value="1">

            <div class="mb-3">
              <label class="form-label">Full Name *</label>
              <input type="text" class="form-control" name="full_name" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Email *</label>
              <input type="email" class="form-control" name="email" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Password *</label>
              <input type="password" class="form-control" name="password" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Employee ID *</label>
              <input type="text" class="form-control" name="employee_id" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Company Name</label>
              <input type="text" class="form-control" name="company_name" value="Tech Solutions Ltd">
            </div>

            <div class="mb-3">
              <label class="form-label">Joining Date *</label>
              <input type="date" class="form-control" name="joining_date" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Monthly Salary (PKR) *</label>
              <input type="number" class="form-control" name="monthly_salary" step="0.01" min="0" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Designation</label>
              <input type="text" class="form-control" name="designation">
            </div>

            <div class="mb-3">
              <label class="form-label">Department</label>
              <input type="text" class="form-control" name="department">
            </div>

            <button type="submit" class="btn btn-primary w-100">
              <i class="bi bi-plus-circle"></i> Add Employee
            </button>
          </form>
        </div>
      </div>
    </div>

    <div class="col-md-8 mb-4">
      <div class="card">
        <div class="card-header">
          <i class="bi bi-people"></i> All Employees
        </div>
        <div class="card-body">
          <?php if (count($employees) > 0): ?>
            <div class="table-responsive">
              <table class="table table-hover data-table">
                <thead>
                  <tr>
                    <th>Emp ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Salary</th>
                    <th>Joining Date</th>
                    <th>Status</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($employees as $emp): ?>
                    <tr>
                      <td><code><?php echo htmlspecialchars($emp['employee_id']); ?></code></td>
                      <td>
                        <strong><?php echo htmlspecialchars($emp['full_name']); ?></strong>
                        <br><small class="text-muted"><?php echo htmlspecialchars($emp['designation']); ?></small>
                      </td>
                      <td><?php echo htmlspecialchars($emp['email']); ?></td>
                      <td><?php echo formatCurrency($emp['monthly_salary']); ?></td>
                      <td><?php echo formatDate($emp['joining_date']); ?></td>
                      <td><?php echo getStatusBadge($emp['status']); ?></td>
                      <td>
                        <a href="payments.php?employee_id=<?php echo $emp['id']; ?>"
                          class="btn btn-sm btn-success" title="Add Payment">
                          <i class="bi bi-cash"></i>
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center py-5">
              <i class="bi bi-inbox display-1 text-muted"></i>
              <p class="text-muted mt-3">No employees found</p>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once '../includes/footer.php'; ?>