<?php
require_once '../config/config.php';
require_once '../includes/functions.php';

requireRole('company');

$stats = getCompanyStats();
$employees = getAllEmployees();

$pageTitle = 'Company Dashboard';
require_once '../includes/header.php';
require_once '../includes/navbar.php';
?>

<div class="container-fluid py-4">
  <!-- Welcome Section -->
  <div class="row mb-4">
    <div class="col-12">
      <div class="card bg-gradient-primary text-white">
        <div class="card-body">
          <h2 class="mb-0">
            <i class="bi bi-building"></i> Company Dashboard
          </h2>
          <p class="mb-0 opacity-75">Manage employees and track salary payments</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Statistics Cards -->
  <div class="row mb-4">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stat-card bg-gradient-primary text-white">
        <div class="icon"><i class="bi bi-people"></i></div>
        <h3><?php echo $stats['total_employees']; ?></h3>
        <p>Total Employees</p>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stat-card bg-gradient-danger text-white">
        <div class="icon"><i class="bi bi-exclamation-circle"></i></div>
        <h3><?php echo formatCurrency($stats['total_pending']); ?></h3>
        <p>Total Pending</p>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stat-card bg-gradient-info text-white">
        <div class="icon"><i class="bi bi-calendar-check"></i></div>
        <h3><?php echo $stats['payments_this_month']; ?></h3>
        <p>Payments This Month</p>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stat-card bg-gradient-success text-white">
        <div class="icon"><i class="bi bi-cash-stack"></i></div>
        <h3><?php echo formatCurrency($stats['total_disbursed']); ?></h3>
        <p>Total Disbursed</p>
      </div>
    </div>
  </div>

  <div class="row">
    <!-- Employees List -->
    <div class="col-md-8 mb-4">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0"><i class="bi bi-people"></i> All Employees</h5>
          <a href="employees.php" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle"></i> Add Employee
          </a>
        </div>
        <div class="card-body">
          <?php if (count($employees) > 0): ?>
            <div class="table-responsive">
              <table class="table table-hover">
                <thead>
                  <tr>
                    <th>Employee ID</th>
                    <th>Name</th>
                    <th>Salary</th>
                    <th>Pending</th>
                    <th>Status</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($employees as $emp): ?>
                    <?php $pending = getPendingAmount($emp['id']); ?>
                    <tr>
                      <td><code><?php echo htmlspecialchars($emp['employee_id']); ?></code></td>
                      <td>
                        <strong><?php echo htmlspecialchars($emp['full_name']); ?></strong>
                        <br><small class="text-muted"><?php echo htmlspecialchars($emp['designation']); ?></small>
                      </td>
                      <td><?php echo formatCurrency($emp['monthly_salary']); ?></td>
                      <td>
                        <?php if ($pending > 0): ?>
                          <span class="text-danger fw-bold"><?php echo formatCurrency($pending); ?></span>
                        <?php else: ?>
                          <span class="text-success">✓ Paid</span>
                        <?php endif; ?>
                      </td>
                      <td><?php echo getStatusBadge($emp['status']); ?></td>
                      <td>
                        <a href="payments.php?employee_id=<?php echo $emp['id']; ?>"
                          class="btn btn-sm btn-success" title="Add Payment">
                          <i class="bi bi-cash"></i>
                        </a>
                        <a href="employees.php?edit=<?php echo $emp['id']; ?>"
                          class="btn btn-sm btn-primary" title="Edit">
                          <i class="bi bi-pencil"></i>
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center py-5">
              <i class="bi bi-people display-1 text-muted"></i>
              <h4 class="mt-3 text-muted">No employees added yet</h4>
              <a href="employees.php" class="btn btn-primary mt-2">
                <i class="bi bi-plus-circle"></i> Add First Employee
              </a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- Quick Payment Entry -->
    <div class="col-md-4 mb-4">
      <div class="card">
        <div class="card-header">
          <i class="bi bi-lightning"></i> Quick Payment
        </div>
        <div class="card-body">
          <form action="payments.php" method="POST">
            <div class="mb-3">
              <label class="form-label">Employee</label>
              <select class="form-select" name="employee_id" required>
                <option value="">Select Employee</option>
                <?php foreach ($employees as $emp): ?>
                  <?php if ($emp['status'] === 'active'): ?>
                    <option value="<?php echo $emp['id']; ?>">
                      <?php echo htmlspecialchars($emp['full_name']); ?>
                      (<?php echo $emp['employee_id']; ?>)
                    </option>
                  <?php endif; ?>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label">Amount</label>
              <input type="number" class="form-control" name="amount"
                step="0.01" min="0" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Payment Method</label>
              <select class="form-select" name="payment_method" required>
                <option value="bank_transfer">Bank Transfer</option>
                <option value="cash">Cash</option>
                <option value="cheque">Cheque</option>
                <option value="online">Online Payment</option>
              </select>
            </div>

            <button type="submit" name="quick_payment" class="btn btn-success w-100">
              <i class="bi bi-check-circle"></i> Add Payment
            </button>
          </form>
        </div>
      </div>

      <!-- Quick Links -->
      <div class="card mt-3">
        <div class="card-header">
          <i class="bi bi-link-45deg"></i> Quick Links
        </div>
        <div class="card-body">
          <div class="d-grid gap-2">
            <a href="employees.php" class="btn btn-outline-primary">
              <i class="bi bi-person-plus"></i> Manage Employees
            </a>
            <a href="payments.php" class="btn btn-outline-success">
              <i class="bi bi-cash-coin"></i> All Payments
            </a>
            <a href="reports.php" class="btn btn-outline-info">
              <i class="bi bi-file-earmark-bar-graph"></i> Reports
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once '../includes/footer.php'; ?>